import React, { useState, useEffect } from "react";
import { useLocation, useHistory, Link } from "react-router-dom";
import { Redirect } from 'react-router';
import { Card, Button, CardGroup, Modal } from 'react-bootstrap';

const Home = (props) => {
	const history = useHistory();
	const search = useLocation().search;
	const [tokenStatus, setTokenStatus] = React.useState(false);
	const shopName = new URLSearchParams(search).get('q');
	
	useEffect(() => {
		if (typeof shopName !== 'undefined')
		{
			localStorage.setItem("shopName",shopName);
			setTokenStatus(true);
		}
		else
		{
			if(localStorage.getItem("shopName") != '')
			{
				setTokenStatus(true);
			}
		}
    },[]);

	return (
		<div>
			<div class="container home_container">
				<ul class="home_tiles">
					<li>
					<Card>
						<Card.Header>Featured</Card.Header>
						<Card.Body>
							<Card.Title>Special title treatment</Card.Title>
							<Card.Text>
							With supporting text below as a natural lead-in to additional content.
							</Card.Text>
							<Button variant="primary">Go somewhere</Button>
						</Card.Body>
					</Card>
					</li>
					<li><Link to="/">View Stores</Link></li>
				</ul>
				
			</div>
		</div>
	  );
};
  
export default Home;