import React, { Component, useState, useEffect, useCallback } from "react";
//import { useHistory } from 'react-router-dom';
//import createApp from '@shopify/app-bridge';
//import { Redirect } from '@shopify/app-bridge/actions';
import { BrowserRouter as Router, Route, Switch, useLocation, useHistory, Link } from "react-router-dom";
import keys from '../constants';
import {AppProvider, Button} from '@shopify/polaris';

const Home = (props) => {
	const history = useHistory();
	const search = useLocation().search;
	const [tokenStatus, setTokenStatus] = React.useState("");
	const shop = new URLSearchParams(search).get('q');
	const shopFullName = shop.split('.');
	const shopName = shopFullName[0];
	
	useEffect(() => {
		localStorage.setItem("shopName",shopName);
    });

	return (
		<div>
		  {tokenStatus ? (
			<div class="container home_container">
				<ul class="home_tiles">
					<li><Link to="/about">Earn Points</Link></li>
					<li><Link to="/contact">Redeem Points</Link></li>
				</ul>
				
			</div>
		  ) : (
			<div class="container">
				<h4>{tokenStatus}</h4>
			</div>
		  )}
		</div>
	  );
};
  
export default Home;