import React, { useState } from "react";
import { AppContext } from "./lib/contextLib";
import { BrowserRouter as Router, Route, Switch, useLocation } from "react-router-dom";
import { Navigation, Footer, Home } from "./components";
import logo from './FS.png'; // with import

function App() {
  const [clientInfo, setClientInfo] = React.useState("");

  function handleChange(newValue) {
    setClientInfo(newValue);
  }

  return (
    <div className="App col-md-12 row">
      <Router>
      <div className="fixedTopBar">
            <img src={logo} />
            <span className="logoutMenu">Logout</span>
          </div>
        <div className="col-md-1 sideMenuBar">
        <Navigation />
        </div>
        <div class="col-md-11 parentBlock">
          
        <Switch>
          <Route path="/home" exact component={() => <Home data={clientInfo} onChange={handleChange} />} render={(props) => <App {...props} />} />
          
        </Switch>
        <Footer />
        </div>
      </Router>
    </div>
  );
}

export default App;